//
//  MDAppDelegate.m
//  OpenGLHighScore
//
//  Created by Mark Douma on 12/5/2011.
//  Copyright (c) 2011 Mark Douma LLC. All rights reserved.
//

#import "MDAppController.h"
#import "MDOpenGLView.h"


@interface MDAppController (MDPrivate)
- (void)showHighScoreWindow:(id)sender;
@end


@implementation MDAppController

@synthesize name;

- (void)dealloc {
	[name release];
    [super dealloc];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification {
	[self performSelector:@selector(showHighScoreWindow:) withObject:nil afterDelay:5.0];
}


- (void)showHighScoreWindow:(id)sender {
	// Check if the highScoreSheet IBOutlet is nil. If it is,
	// that means the MDHighScoreWindow.nib file hasn't been loaded yet.
	// When we use NSBundle's methods to load the nib with ourselves as
	// the owner, then the highScoreSheet will be set, and subsequent calls of
	// this method will use the existing instance
	
	if (highScoreSheet == nil) {
		if (![NSBundle loadNibNamed:@"MDHighScoreWindow" owner:self]) {
			NSLog(@"failed to load MDHighScoreWindow nib!");
		}
	}
	
	// set a default value of the user's full user name
	
	[self setName:NSFullUserName()];
	
	[NSApp beginSheet:highScoreSheet
	   modalForWindow:window
		modalDelegate:self
	   didEndSelector:@selector(highScoreSheetDidEnd:returnCode:contextInfo:)
		  contextInfo:NULL];
}


// as the user types, validate the input to disable OK button
// if they have an empty string
- (void)controlTextDidChange:(NSNotification *)notification {
	NSString *newStringValue = [[notification object] stringValue];
	if (newStringValue == nil || [newStringValue length] == 0) {
		[highScoreOKButton setEnabled:NO];
	} else {
		[highScoreOKButton setEnabled:YES];
	}
}

- (IBAction)highScoreOK:(id)sender {
	[NSApp endSheet:highScoreSheet];
}

- (void)highScoreSheetDidEnd:(NSWindow *)sheet
				  returnCode:(NSInteger)returnCode
				 contextInfo:(void *)contextInfo {
	
	[sheet orderOut:nil];
	
	// you'd now do something with the name and high score, etc.
	NSLog(@"name == %@", name);
}
	 
	 

@end



